/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.common.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;
import xfacthd.buddingcrystals.common.BCContent;
import xfacthd.buddingcrystals.common.block.BuddingCrystalBlock;
import xfacthd.buddingcrystals.common.util.BudSet;
import xfacthd.buddingcrystals.common.util.CrystalSet;

public final class CrystalLoader {
    private static final Pattern VALID_NAME = Pattern.compile("^[a-z][a-z\\d_]+$");
    public static final Path CRYSTAL_PATH = FMLPaths.GAMEDIR.get().resolve("buddingcrystals");
    static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void loadUserSets() {
        LOGGER.info("Loading custom crystal definitions");
        Stopwatch stopwatch = Stopwatch.createStarted();
        FileUtils.getOrCreateDirectory((Path)CRYSTAL_PATH, (String)"BuddingCrystals crystal definitions");
        try (Stream<Path> paths = Files.list(CRYSTAL_PATH);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(filePath -> filePath.toString().endsWith(".json")).filter(CrystalLoader::filterBuiltins).forEach(filePath -> {
                String name = CrystalLoader.getName(filePath);
                if (!VALID_NAME.matcher(name).matches()) {
                    LOGGER.error("Invalid crystal definition name {}, does not match pattern {} ", (Object)name, (Object)VALID_NAME.pattern());
                    return;
                }
                try {
                    JsonObject json = CrystalLoader.readJsonFile(filePath);
                    CrystalLoader.loadDefinition(name, json);
                }
                catch (JsonParseException e) {
                    LOGGER.error("Encountered an error while loading crystal definition for '" + name + "'", (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Encountered an error while loading crystal definitions", (Throwable)e);
        }
        stopwatch.stop();
        LOGGER.info("Crystal definitions loaded in {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public static void overrideFromJson(String name, CrystalSet.Builder builder) {
        Path file = CRYSTAL_PATH.resolve(name + ".json");
        if (Files.exists(file, new LinkOption[0])) {
            CrystalDefinition def;
            try {
                JsonObject json = CrystalLoader.readJsonFile(file);
                def = CrystalLoader.parseJson(json);
            }
            catch (JsonParseException e) {
                LOGGER.error("Encountered an error while loading override for builtin CrystalSet '" + name + "'", (Throwable)e);
                return;
            }
            builder.translation(def.translation).compatMod(def.compatMod).buddingSourceTexture(def.buddingTexture).crystalSourceTexture(def.crystalTexture).growthChance(def.growthChance).ingredient(def.ingredientName).drop(def.dropName).normalDrop(def.normalDrop).maxDrop(def.maxDrop);
        }
    }

    public static void updateFromJson(Update type) {
        BCContent.allSets().forEach(set -> {
            Path filePath = CRYSTAL_PATH.resolve(set.getName() + ".json");
            if (!Files.exists(filePath, new LinkOption[0])) {
                if (!BCContent.builtinSets().contains(set)) {
                    LOGGER.error("Crystal definition for '{}' went missing after startup!", (Object)set.getName());
                }
                return;
            }
            try {
                JsonObject json = CrystalLoader.readJsonFile(filePath);
                CrystalDefinition def = CrystalLoader.parseJson(json);
                if (type == Update.SERVER) {
                    set.updateServerData(def.dropName, def.ingredientName, def.normalDrop, def.maxDrop);
                } else {
                    set.updateClientData(def.translation, def.crystalTexture, def.buddingTexture);
                }
            }
            catch (JsonParseException e) {
                LOGGER.error("Encountered an error while updating crystal definition for '" + set.getName() + "'", (Throwable)e);
            }
        });
    }

    public static String export(String name) {
        ResourceLocation budding;
        ResourceLocation crystal;
        CrystalSet set = BCContent.BUILTIN_SETS.get(name);
        JsonObject json = new JsonObject();
        json.addProperty("translation", set.getTranslation());
        if (!set.getCompatMod().equals("minecraft")) {
            json.addProperty("compat_mod", set.getCompatMod());
        }
        if ((crystal = set.getCrystalSourceTexture()).equals((Object)(budding = set.getBuddingSourceTexture()))) {
            json.addProperty("texture", crystal.toString());
        } else {
            json.addProperty("crystal_texture", crystal.toString());
            json.addProperty("budding_textures", budding.toString());
        }
        json.addProperty("growth_chance", (Number)set.getGrowthChance());
        ResourceLocation dropped = (ResourceLocation)Preconditions.checkNotNull((Object)set.getDroppedItem().getRegistryName());
        ResourceLocation ingredient = (ResourceLocation)Preconditions.checkNotNull((Object)set.getIngredient().getRegistryName());
        json.addProperty("dropped_item", dropped.toString());
        if (!dropped.equals((Object)ingredient)) {
            json.addProperty("recipe_item", ingredient.toString());
        }
        json.addProperty("normal_drop_chance", (Number)Float.valueOf(set.getNormalDrops()));
        json.addProperty("max_drop_chance", (Number)Float.valueOf(set.getMaxDrops()));
        return GSON.toJson((JsonElement)json);
    }

    private static JsonObject readJsonFile(Path path) {
        try {
            BufferedReader reader = Files.newBufferedReader(path);
            JsonObject json = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
            ((Reader)reader).close();
            return json;
        }
        catch (IOException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }

    private static void loadDefinition(String name, JsonObject json) {
        RegistryObject drop;
        CrystalDefinition def = CrystalLoader.parseJson(json);
        RegistryObject ingredient = drop = RegistryObject.create((ResourceLocation)def.dropName, (IForgeRegistry)ForgeRegistries.ITEMS);
        if (!def.dropName.equals((Object)def.ingredientName)) {
            ingredient = RegistryObject.create((ResourceLocation)def.ingredientName, (IForgeRegistry)ForgeRegistries.ITEMS);
        }
        RegistryObject<Block> smallBud = CrystalSet.Builder.register("small_" + name + "_bud", CrystalSet.Builder::smallBud, def.compatMod);
        RegistryObject<Block> mediumBud = CrystalSet.Builder.register("medium_" + name + "_bud", CrystalSet.Builder::mediumBud, def.compatMod);
        RegistryObject<Block> largeBud = CrystalSet.Builder.register("large_" + name + "_bud", CrystalSet.Builder::largeBud, def.compatMod);
        RegistryObject<Block> cluster = CrystalSet.Builder.register(name + "_cluster", CrystalSet.Builder::cluster, def.compatMod);
        BudSet budSet = new BudSet(smallBud, mediumBud, largeBud, cluster);
        RegistryObject<Block> buddingBlock = CrystalSet.Builder.register("budding_" + name, () -> new BuddingCrystalBlock(budSet, def.growthChance, BlockBehaviour.Properties.m_60939_((Material)Material.f_164531_).m_60977_().m_60978_(1.5f).m_60918_(SoundType.f_154654_).m_60999_()), def.compatMod);
        CrystalSet set = new CrystalSet(def.compatMod, name, def.translation, def.crystalTexture, def.buddingTexture, def.growthChance, buddingBlock, budSet, (RegistryObject<Item>)drop, (RegistryObject<Item>)ingredient, def.normalDrop, def.maxDrop);
        BCContent.ALL_SETS.put(name, set);
        BCContent.LOADED_SETS.put(name, set);
    }

    private static CrystalDefinition parseJson(JsonObject json) {
        String buddingTex;
        String crystalTex;
        Predicate<String> stringValidator = s -> s != null && !s.isEmpty();
        String compatMod = CrystalLoader.getString(json, "compat_mod", "minecraft", stringValidator, "Compat mod must not be empty");
        String translation = CrystalLoader.getString(json, "translation", stringValidator, "Translation must not be empty");
        if (json.has("crystal_texture") && json.has("budding_texture")) {
            crystalTex = CrystalLoader.getString(json, "crystal_texture", stringValidator, "Crystal texture must not be empty");
            buddingTex = CrystalLoader.getString(json, "budding_texture", stringValidator, "Budding texture must not be empty");
        } else {
            crystalTex = buddingTex = CrystalLoader.getString(json, "texture", stringValidator, "Texture must not be empty");
        }
        ResourceLocation crystalTexture = ResourceLocation.m_135820_((String)crystalTex);
        ResourceLocation buddingTexture = ResourceLocation.m_135820_((String)buddingTex);
        int growthChance = CrystalLoader.getInt(json, "growth_chance", i -> i > 0, "Growth chance must be higher than 0");
        ResourceLocation dropName = CrystalLoader.getResLoc(json, "dropped_item");
        ResourceLocation recipeName = CrystalLoader.getResLoc(json, "recipe_item", dropName.toString());
        float normalDrop = CrystalLoader.getFloat(json, "normal_drop_chance", f -> f.floatValue() > 0.0f, "Normal drop count must be higher than 0");
        float maxDrop = CrystalLoader.getFloat(json, "max_drop_chance", f -> f.floatValue() > 0.0f, "Max drop count must be higher than 0");
        return new CrystalDefinition(compatMod, translation, crystalTexture, buddingTexture, growthChance, recipeName, dropName, normalDrop, maxDrop);
    }

    private static ResourceLocation getResLoc(JsonObject json, String key, String _default) {
        try {
            return new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)key, (String)_default));
        }
        catch (ResourceLocationException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }

    private static ResourceLocation getResLoc(JsonObject json, String key) {
        try {
            return new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)key));
        }
        catch (ResourceLocationException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }

    private static String getString(JsonObject json, String key, String _default, Predicate<String> validator, String message) {
        String value = GsonHelper.m_13851_((JsonObject)json, (String)key, (String)_default);
        return CrystalLoader.validate(value, validator, message);
    }

    private static String getString(JsonObject json, String key, Predicate<String> validator, String message) {
        String value = GsonHelper.m_13906_((JsonObject)json, (String)key);
        return CrystalLoader.validate(value, validator, message);
    }

    private static int getInt(JsonObject json, String key, Predicate<Integer> validator, String message) {
        int value = GsonHelper.m_13927_((JsonObject)json, (String)key);
        return CrystalLoader.validate(value, validator, message);
    }

    private static float getFloat(JsonObject json, String key, Predicate<Float> validator, String message) {
        float value = GsonHelper.m_13927_((JsonObject)json, (String)key);
        return CrystalLoader.validate(Float.valueOf(value), validator, message).floatValue();
    }

    private static <T> T validate(T value, Predicate<T> validator, String message) {
        if (!validator.test(value)) {
            throw new JsonSyntaxException(message);
        }
        return value;
    }

    private static String getName(Path path) {
        String file = path.getFileName().toString();
        return file.substring(0, file.indexOf(46));
    }

    private static boolean filterBuiltins(Path path) {
        String name = CrystalLoader.getName(path);
        return !name.equals("amethyst") && !BCContent.BUILTIN_SETS.containsKey(name);
    }

    private record CrystalDefinition(String compatMod, String translation, ResourceLocation crystalTexture, ResourceLocation buddingTexture, int growthChance, ResourceLocation ingredientName, ResourceLocation dropName, float normalDrop, float maxDrop) {
    }

    public static enum Update {
        SERVER,
        CLIENT;


        public static Update fromPackType(PackType type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case PackType.CLIENT_RESOURCES -> CLIENT;
                case PackType.SERVER_DATA -> SERVER;
            };
        }
    }
}

